'  Public definitions for the 16-bit EGI player DLL.
'  Include this file in Visual Basic applications that use
'  EPLAY.DLL.
'
'  Version 1.2
'  (c) Copyright ITB CompuPhase, 1996-1997

' Types
Type Rectangle
  Left As Integer
  Top As Integer
  Right A Integer
  Bottom As Integer
End Type

' Functions
Declare Function FlicClose Lib "eplay.dll" (ByVal Flic&) As Boolean
Declare Function FlicCreateWindow Lib "eplay.dll" (ByVal Caption$,ByVal Style&,ByVal X%,ByVal Y%,ByVal WinWidth%,ByVal WinHeight%,ByVal hwndParent%,ByVal Instance%) as Integer
Declare Function FlicError Lib "eplay.dll" (ByVal Flic&) As Integer
Declare Function FlicGetData Lib "eplay.dll" (ByVal Flic&,ByVal code%) As Long
Declare Function FlicGetHandle Lib "eplay.dll" (ByVal Flic&,ByVal hdc%,ByVal code%) As Integer
Declare Function FlicGetParam Lib "eplay.dll" (ByVal Flic&,ByVal code%) as Integer
Declare Function FlicGetRect Lib "eplay.dll" (ByVal Flic&,ByVal code%,Rect as Rectangle) As Boolean
Declare Function FlicNextFrame Lib "eplay.dll" (ByVal Flic&) as Integer
Declare Function FlicOpen Lib "eplay.dll" (ByVal Filename$) As Long
Declare Function FlicPaint Lib "eplay.dll" (ByVal Flic&,ByVal hdc%,ByVal PaintAll As Boolean) As Integer
Declare Function FlicPlay Lib "eplay.dll" (ByVal Flic&,ByVal hwnd%) As Boolean
Declare Function FlicSetHandle Lib "eplay.dll" (ByVal Flic&,ByVal code%,ByVal handle%) As Boolean
Declare Function FlicSetParam Lib "eplay.dll" (ByVal Flic&,ByVal code%,ByVal value%) As Boolean
Declare Function FlicStop Lib "eplay.dll" (ByVal Flic&) As Boolean

' Parameters for FlicGetParam and FlicSetParam
Global Const FLIC_PARAM_ISPLAYING  = 0 ' 1=FLIC file is currently playing
Global Const FLIC_PARAM_WIDTH      = 1
Global Const FLIC_PARAM_HEIGHT     = 2
Global Const FLIC_PARAM_NUMFRAMES  = 3 ' total number of frames
Global Const FLIC_PARAM_CURFRAME   = 4 ' current frame number
Global Const FLIC_PARAM_CONTINUOUS = 5 ' segment is continuous (it has a ring frame)
Global Const FLIC_PARAM_SPEED      = 6 ' playback speed, set to 0 for max. speed
Global Const FLIC_PARAM_DESIGNSPEED= 7 ' design speed, read from FLIC file
Global Const FLIC_PARAM_REALSPEED  = 8 ' real playback speed
Global Const FLIC_PARAM_MODE       = 9 ' BitBlt mode
Global Const FLIC_PARAM_LOOP       =10 ' loop frames or only play once
Global Const FLIC_PARAM_NUMSEGMENTS=11
Global Const FLIC_PARAM_CURSEGMENT =12
Global Const FLIC_PARAM_XPOS       =13 ' position of the animation in the window
Global Const FLIC_PARAM_YPOS       =14
Global Const FLIC_PARAM_LABEL      =15 ' label of the current frame (-1 if none)
Global Const FLIC_PARAM_CHGPAL     =16 ' obscoleted by FLIC_PARAM_PALMODE
Global Const FLIC_PARAM_VERSION    =17 ' current version of EGI player
Global Const FLIC_PARAM_SEGLABEL   =18 ' the label of the current segment
Global Const FLIC_PARAM_DRAWFRAME  =19 ' draw the frames?
Global Const FLIC_PARAM_FRNOTIFY   =20 ' notify for each frame?
Global Const FLIC_PARAM_MASK       =21 ' masks present (0=no, 1=bitmap, 2=skip-copy, 3=both)
Global Const FLIC_PARAM_ID         =22 ' user specified id
Global Const FLIC_PARAM_MSGNUM     =23 ' value of FLIC_NOTIFY
Global Const FLIC_PARAM_KEYFREQ    =24 ' key frame interval (0 if there are no key frames)
Global Const FLIC_PARAM_SKIPDELTAS =25 ' skip all delta frames up to the next key frame
Global Const FLIC_PARAM_PALMODE    =26 ' set the palette mode

' Values for FLIC_PARAM_MODE
Global Const FLIC_MODE_BITBLT      = 0
Global Const FLIC_MODE_DIBTODEV    = 1
Global Const FLIC_MODE_STRETCHDIB  = 2
Global Const FLIC_MODE_WING        = 3 ' no longer supported
Global Const FLIC_MODE_DIBSECTION  = 4
Global Const FLIC_MODES            = 5 ' number of modes

' Values for FLIC_PARAM_PALMODE
Global Const FLIC_PAL_ADAPT        = 0 ' adapt to system palette
Global Const FLIC_PAL_ANIM         = 1 ' use palette from FLIC file (default)
Global Const FLIC_PAL_SPECIFIC     = 2 ' use palette set with FlicSetHandle
Global Const FLIC_PALMODES         = 3 ' number of palette modes

' Parameters for FlicGetData
Global Const FLIC_DATA_BITMAP      = 0 ' pointer to the pixel data
Global Const FLIC_DATA_PALETTE     = 1 ' pointer to the RGB table
Global Const FLIC_DATA_MASK        = 2 ' pointer to the bitmap mask data
Global Const FLIC_DATA_BITMAPINFO  = 3 ' pointer to the DIB header

' Parameters for FlicGetHandle and FlicSetHandle
Global Const FLIC_HANDLE_PALETTE   = 0 ' handle to the palette
Global Const FLIC_HANDLE_BITMAP    = 1 ' handle to device dependent bitmap of the frame
Global Const FLIC_HANDLE_MASK      = 2 ' handle to the bitmap mask
Global Const FLIC_HANDLE_WINGDC    = 3 ' no longer supported
Global Const FLIC_HANDLE_WINGBMP   = 4 ' no longer supported
Global Const FLIC_HANDLE_MUTEX     = 5 ' handle to Win32 "mutex" semaphore for bitmap

' Parameters for FlicGetRect
Global Const FLIC_RECT_BOUNDING    = 0 ' bounding box of frame differences */
Global Const FLIC_RECT_MASK        = 1 ' bounding box of the mask */
Global Const FLIC_RECT_FIRST       = 2 ' first rectangle of the region of frame differences */
Global Const FLIC_RECT_NEXT        = 3 ' next rectangle of the region of frame differences */

' Returned bits for FlicNextFrame
Global Const FLIC_FRAME_PAL        = &H1  ' palette needs updating
Global Const FLIC_FRAME_IMG        = &H2  ' image needs updating, use FlicPaint()
Global Const FLIC_FRAME_LAST       = &H4  ' last frame has played
Global Const FLIC_FRAME_RING       = &H8  ' ring frame has played (reset to 2nd frame)
Global Const FLIC_FRAME_LABEL      = &H10 ' a label was reached
Global Const FLIC_FRAME_DECODED    = &H8000 ' frame was successfully decoded

' Returned values for FlicError
Global Const FLIC_ERR_NONE         = 0
Global Const FLIC_ERR_FOPEN        = 1
Global Const FLIC_ERR_FORMAT       = 2
Global Const FLIC_ERR_FREAD        = 3
Global Const FLIC_ERR_MEMORY       = 4
Global Const FLIC_ERR_PARAM        = 5
Global Const FLIC_ERR_INVALID      = 6
Global Const FLIC_ERR_MUTEX        = 7
Global Const FLIC_ERR_UNSUPPORTED  = 8

' Message posted to the owner window when a label is reached or a segment ends
Global Const FLIC_NOTIFY           = &H400+98
' Values for wParam upon receipt of FLIC_NOTIFY
Global Const FN_LABEL              = 0 ' reached a label (LOWORD(lParam)==label)
Global Const FN_LASTFRAME          = 1 ' played last frame
Global Const FN_FRAME              = 2 ' played (another) frame

